//=============================================================================

/*:
 * @plugindesc 特定条件でのみエンカウントする敵グループを設定できるようにします。
 * 
 * @author LefTonbo
 *
 * @help
 * 敵グループのイベント注釈にエンカウント条件を記述します。
 * <Appear Switch On: x>  :  スイッチ x が ON のときのみ
 * <Appear Switch Off: x>  :  スイッチ x が OFF のときのみ
 * <Appear Variable x Above: y>  :  変数 x が y 以上のときのみ
 * <Appear Variable x Below: y>  :  変数 x が y 以下のときのみ
 */

//=============================================================================

var Imported = Imported || {};
Imported.LP_TroopWithConditions = true;

var LeftPlugin = LeftPlugin || {};

//=============================================================================

(function() {

//=============================================================================
// DataManager
//=============================================================================

var _DataManager_isDatabaseLoaded = DataManager.isDatabaseLoaded;
DataManager.isDatabaseLoaded = function() {
  if (!_DataManager_isDatabaseLoaded.call(this)) return false;

  if (!LeftPlugin._loaded_TroopWithConditions) {
    this.processTroopConditionNotes($dataTroops);
    LeftPlugin._loaded_TroopWithConditions = true;
  }
  
  return true;
};

DataManager.processTroopConditionNotes = function(group) {
  var length = group.length;
  for (var t = 1; t < length; t++) {
    var troop = group[t];
    if (!troop) continue;
    troop.meetConditions = {};
    var pageLength = troop.pages.length;
    for (var p = 0; p < pageLength; ++p) {
      var page = troop.pages[p];
      if (page) this.processTroopConditionTags(troop, page);
    }
  }
};

DataManager.processTroopConditionTags = function(troop, page) {
  var length = page.list.length;
  var checked = false;
  for (var i = 0; i < length; i++) {
    var pageItem = page.list[i];
    if (pageItem) {
      if (pageItem.code === 108 || pageItem.code === 408) {
        var line = pageItem.parameters[0];
        if (line) {
          if (line.match(/<APPEAR SWITCH OFF:[ ](.*)>/i)) {
            troop.meetConditions['sw-off'] = parseInt(RegExp.$1);
            checked = true;
          } else if (line.match(/<APPEAR SWITCH ON:[ ](.*)>/i)) {
            troop.meetConditions['sw-on'] = parseInt(RegExp.$1);
            checked = true;
          } else if (line.match(/<APPEAR VARIABLE (\d*) BELOW:[ ](.*)>/i)) {
            troop.meetConditions['v-b'] = parseInt(RegExp.$1);
            troop.meetConditions['v-v'] = parseInt(RegExp.$2);
            checked = true;
          } else if (line.match(/<APPEAR VARIABLE (\d*) ABOVE:[ ](.*)>/i)) {
            troop.meetConditions['v-a'] = parseInt(RegExp.$1);
            troop.meetConditions['v-v'] = parseInt(RegExp.$2);
            checked = true;
          }
        }
      }
    }
    if (checked) {
      break;
    }
  }
};


//=============================================================================
// Game_Player
//=============================================================================

var _Game_Player_meetsEncounterConditions = Game_Player.prototype.meetsEncounterConditions;
Game_Player.prototype.meetsEncounterConditions = function(encounter) {
  var ret = _Game_Player_meetsEncounterConditions.call(this, encounter);
  if (!ret) return false;
  var troop = $dataTroops[encounter.troopId];
  var cond = troop.meetConditions;
  if (Object.keys(cond).length == 0) return true;
  if (cond['sw-off'] && $gameSwitches.value(cond['sw-off']) != false) return false;
  if (cond['sw-on']  && $gameSwitches.value(cond['sw-on'] ) !=  true) return false;
  if (cond['v-v'] != undefined) {
    if (cond['v-b'] && $gameVariables.value(cond['v-b']) > cond['v-v']) return false;
    if (cond['v-a'] && $gameVariables.value(cond['v-a']) < cond['v-v']) return false;
  }
  return true;
}

//=============================================================================

})();

// EOF